/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IPerkProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.container.CrystalFusionStationContainer;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.item.perk.Crystal;
import dev.toma.gunsrpg.common.item.perk.CrystalItem;
import dev.toma.gunsrpg.common.item.perk.PerkVariant;
import dev.toma.gunsrpg.common.tileentity.CrystalFusionStationTileEntity;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_FusePacket;
import dev.toma.gunsrpg.resource.perks.FusionConfiguration;
import dev.toma.gunsrpg.resource.perks.PerkConfiguration;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CrystalFuseStationScreen
extends ContainerScreen<CrystalFusionStationContainer> {
    private static final ResourceLocation BG = GunsRPG.makeResource("textures/screen/fusion_station.png");
    private static final ITextComponent BUTTON_FUSE = new TranslationTextComponent("screen.button.fuse_crystals");
    private static final DecimalFormat FORMAT;
    private final ItemStack renderItem = new ItemStack((IItemProvider)ModItems.PERKPOINT_BOOK);
    private IPlayerData data;
    private Button fuseButton;

    public CrystalFuseStationScreen(CrystalFusionStationContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        this.field_147000_g = 164;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.data = PlayerData.getUnsafe((PlayerEntity)this.field_230706_i_.field_71439_g);
        this.fuseButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 61, this.field_147009_r + 55, 54, 20, BUTTON_FUSE, this::fuseButtonClicked));
        this.updateButtonState();
    }

    protected void func_184098_a(Slot slot, int mouseX, int mouseY, ClickType type) {
        super.func_184098_a(slot, mouseX, mouseY, type);
        this.updateButtonState();
    }

    protected void func_230450_a_(MatrixStack matrix, float partialRenderTicks, int mouseX, int mouseY) {
        float chance2;
        float chance1;
        PerkVariant variant2;
        boolean areSameInputs;
        this.field_230706_i_.func_110434_K().func_110577_a(BG);
        this.func_238474_b_(matrix, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_230706_i_.func_175599_af().func_175042_a(this.renderItem, this.field_147003_i + this.field_146999_f - 22, this.field_147009_r + 63);
        IPerkProvider provider = this.data.getPerkProvider();
        String text = String.valueOf(provider.getPoints());
        int fundsWidth = this.field_230712_o_.func_78256_a(text);
        this.field_230712_o_.func_238421_b_(matrix, text, (float)(this.field_147003_i + this.field_146999_f - 24 - fundsWidth), (float)(this.field_147009_r + 68), 43775);
        CrystalFusionStationTileEntity tileEntity = (CrystalFusionStationTileEntity)((Object)((CrystalFusionStationContainer)this.field_147002_h).getTileEntity());
        IItemHandlerModifiable itemHandler = tileEntity.getItemHandler();
        int orbCount = (int)Arrays.stream(CrystalFusionStationTileEntity.ORBS).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(stack -> !stack.func_190926_b()).count();
        int price = this.getPrice(orbCount);
        PerkConfiguration perkConfig = GunsRPG.getModLifecycle().getPerkManager().configLoader.getConfiguration();
        FusionConfiguration fusionConfig = perkConfig.getFusionConfig();
        FusionConfiguration.Swap swapConfig = fusionConfig.getSwaps().getSwapStat(orbCount);
        if (price > 0) {
            this.field_230712_o_.func_238421_b_(matrix, "\u6210\u672c: " + price, (float)(this.field_147003_i + 6), (float)(this.field_147009_r + 68), 0x404040);
        }
        ItemStack item1 = itemHandler.getStackInSlot(1);
        ItemStack item2 = itemHandler.getStackInSlot(2);
        if (item1.func_190926_b() || item2.func_190926_b()) {
            return;
        }
        Crystal crystal1 = CrystalItem.getCrystal(item1);
        Crystal crystal2 = CrystalItem.getCrystal(item2);
        PerkVariant variant1 = tileEntity.getItemVariant(item1);
        boolean bl = areSameInputs = variant1 == (variant2 = tileEntity.getItemVariant(item2));
        if (crystal1 != null && crystal2 != null) {
            FusionConfiguration.BreakChanceReduction reduction;
            int targetLevel = crystal1.getLevel() + crystal2.getLevel();
            FusionConfiguration.Upgrade upgrade = fusionConfig.getUpgrades().getUpgradeStat(targetLevel);
            float breakChance = upgrade.getBreakChance();
            if (areSameInputs && (reduction = fusionConfig.getBreakChanceReductions().getReductionForOrbs(orbCount)) != null) {
                breakChance *= reduction.getMultiplier();
            }
            String breakChanceText = "\u635f\u574f\u7387: " + FORMAT.format(breakChance * 100.0f) + "%";
            this.field_230712_o_.func_238421_b_(matrix, breakChanceText, (float)(this.field_147003_i + 6), (float)(this.field_147009_r + 58), 0x404040);
        }
        PerkVariant targetVariant = tileEntity.getTargetedOrbType();
        if (areSameInputs) {
            return;
        }
        if (targetVariant == null) {
            chance1 = 0.5f;
            chance2 = 0.5f;
        } else {
            float swapChance = swapConfig.getChance();
            float chance = 1.0f - swapChance;
            chance1 = variant1 == targetVariant ? swapChance : chance;
            chance2 = variant2 == targetVariant ? swapChance : chance;
        }
        String text1 = Math.round(chance1 * 100.0f) + "%";
        String text2 = Math.round(chance2 * 100.0f) + "%";
        this.field_230712_o_.func_238421_b_(matrix, text1, (float)(this.field_147003_i + 38) + (float)(this.field_230712_o_.func_78256_a(text1) - 18) / 2.0f, (float)(this.field_147009_r + 30), variant1.getRgb());
        this.field_230712_o_.func_238421_b_(matrix, text2, (float)(this.field_147003_i + 122) + (float)(this.field_230712_o_.func_78256_a(text2) - 18) / 2.0f, (float)(this.field_147009_r + 30), variant2.getRgb());
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
    }

    private void fuseButtonClicked(Button button) {
        NetworkManager.sendServerPacket(new C2S_FusePacket((CrystalFusionStationTileEntity)((Object)((CrystalFusionStationContainer)this.field_147002_h).getTileEntity())));
    }

    private void updateButtonState() {
        this.fuseButton.field_230693_o_ = ((CrystalFusionStationTileEntity)((Object)((CrystalFusionStationContainer)this.field_147002_h).getTileEntity())).canFuse((PlayerEntity)this.field_230706_i_.field_71439_g);
    }

    private int getPrice(int orbCount) {
        PerkConfiguration perkConfig = GunsRPG.getModLifecycle().getPerkManager().configLoader.getConfiguration();
        FusionConfiguration fusionConfig = perkConfig.getFusionConfig();
        CrystalFusionStationTileEntity tileEntity = (CrystalFusionStationTileEntity)((Object)((CrystalFusionStationContainer)this.field_147002_h).getTileEntity());
        IItemHandlerModifiable itemHandler = tileEntity.getItemHandler();
        FusionConfiguration.Swap swapConfig = fusionConfig.getSwaps().getSwapStat(orbCount);
        Crystal crystal1 = CrystalItem.getCrystal(itemHandler.getStackInSlot(CrystalFusionStationTileEntity.INPUTS[0]));
        Crystal crystal2 = CrystalItem.getCrystal(itemHandler.getStackInSlot(CrystalFusionStationTileEntity.INPUTS[1]));
        if (crystal1 == null || crystal2 == null) {
            return 0;
        }
        int targetLevel = crystal1.getLevel() + crystal2.getLevel();
        FusionConfiguration.Upgrade upgrade = fusionConfig.getUpgrades().getUpgradeStat(targetLevel);
        if (upgrade == null) {
            return 0;
        }
        return upgrade.getPrice() + swapConfig.getPrice();
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        FORMAT = new DecimalFormat("0.0", symbols);
    }
}

